package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bVoces;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bBeans.W83bVocesBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaVocesExcelAction.
 *
 * @author jrgil
 */
public class W83bTablaVocesExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
		W83bVocesBean vocesBean = (W83bVocesBean)contexto.get("w83bVocesBean");
		contexto.set("w83bVocesTempBean",vocesBean);
	}
	
	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoVoces.xls";
		InputStream inputStream = W83bTablaVocesExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaVoces = (ArrayList)contexto.get("w83bListaVoces");
        W83bVocesBean vocesBean = (W83bVocesBean)contexto.get("w83bVocesTempBean");                   
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                   
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                   
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                   
     
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                   
        HashMap mapaVoces=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                   
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                   
        HSSFCell cell = row.createCell((short)3);                   
        row = sheet.getRow((short)4);                   
        cell = row.getCell((short)5);                   
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaVoces.get("tituloDepEs");                   
        StringBuffer tituloImagenEu =  (StringBuffer)mapaVoces.get("tituloDepEu");                   
        cell.setCellValue(tituloImagenEu.toString());                   
        
        cell = row.getCell((short)8);                   
        cell.setCellValue(tituloImagenEs.toString());                   
        
        tituloImagenEs = (StringBuffer)mapaVoces.get("tituloDelelegacionEs");                   
        tituloImagenEu = (StringBuffer)mapaVoces.get("tituloDelelegacionEu");                   
        row = sheet.getRow((short)6);                   
        cell = row.getCell((short)5);                   
        cell.setCellValue(tituloImagenEu.toString());                   
        
        cell = row.getCell((short)8);                   
        cell.setCellValue(tituloImagenEs.toString());                   
        
        row = sheet.getRow((short)9);                   
        cell = row.getCell((short)0);                   
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.voces.listadoVoces").toUpperCase());                   
        
        //MAPEO FORMULARIO
      //fila 11, columna 2
        row = sheet.getRow(Short.parseShort("12"));
        cell = row.getCell(Short.parseShort("2"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.voces.codVozTabla"));
        cell = row.createCell(Short.parseShort("4"));
        if(!StringUtils.isEmpty(vocesBean.getCodVoz())){
        	cell.setCellValue(W83bUtilidades.numero(vocesBean.getCodVoz()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        //hasta el 11
      //fila 12, columna 2
        row = sheet.getRow(Short.parseShort("13"));
        cell = row.getCell(Short.parseShort("2"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.descTVozTabla"));
        cell = row.createCell(Short.parseShort("4"));
        if(StringUtils.isNotEmpty(vocesBean.getTipoVozDesc())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("4"),W83bClsConstantes.TRECE,Short.parseShort("7")));//NOPMD
        	cell.setCellValue(vocesBean.getTipoVozDesc().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }

        //fila 12, columna 5
        cell = row.getCell(Short.parseShort("8"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.voces.descVocesCastBusq"));
        cell = row.createCell(Short.parseShort("11"));
        if(StringUtils.isNotEmpty(vocesBean.getDescVoz())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("11"),W83bClsConstantes.TRECE,Short.parseShort("15")));//NOPMD
        	cell.setCellValue(vocesBean.getDescVoz().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        	if(81<vocesBean.getDescVoz().length()){
        		row.setHeightInPoints((short)(18*((vocesBean.getDescVoz()).length()/81)+1));
        	}
        }else{
        	cell.setCellValue("");
        }
        
        //fila 13, columna 2
        row = sheet.getRow(Short.parseShort("14"));
        cell = row.getCell(Short.parseShort("2"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.baja"));        
        cell = row.createCell(Short.parseShort("4"));
        if(StringUtils.isEmpty(vocesBean.getBaja())||W83bClsConstantes.CONSTANTE_NO.equals(vocesBean.getBaja())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        	
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
  	        	
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        //fila 13, columna 5
        cell = row.getCell(Short.parseShort("8"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.voces.descVocesEuskBusq"));
        cell = row.createCell(Short.parseShort("11"));
        if(StringUtils.isNotEmpty(vocesBean.getDescVozEusk())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("11"),W83bClsConstantes.CATORCE,Short.parseShort("15")));//NOPMD
        	cell.setCellValue(vocesBean.getDescVozEusk().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        	if(81<vocesBean.getDescVozEusk().length()){
        		row.setHeightInPoints((short)(18*((vocesBean.getDescVozEusk()).length()/81)+1));
        	}
        }else{
        	cell.setCellValue("");
        }
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamanyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("17")); // Creacin de la fila 16

        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 3 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.voces.codVozTabla"));
        
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 2 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.codTipoVozTabla"));
        
        cell = row.getCell(Short.parseShort("5")); // Creacin de la columna 4 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.voces.descVocesCastBusq"));
        
        // 3 columna del titulo del listado
        cell = row.getCell(Short.parseShort("10")); // Creacin de la columna 5 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.voces.descVocesEuskBusq"));


        for(int i=0;i<listaVoces.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECIOCHO+i); // Creacin de la fila 17//NOPMD

        	//Cod Voz
        	cell = row.createCell(Short.parseShort("0"));
        	if(StringUtils.isNotEmpty(((W83bVocesBean)listaVoces.get(i)).getCodVoz())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bVocesBean)listaVoces.get(i)).getCodVoz()));
        	}else{
        		cell.setCellValue("");
        	}
        	
        	
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));

        	//Desc TiposVoz
        	cell = row.createCell(Short.parseShort("1"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("1"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("4")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bVocesBean)listaVoces.get(i)).getTipoVozDesc())){
        		cell.setCellValue(((W83bVocesBean)listaVoces.get(i)).getTipoVozDesc());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("2")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	if(StringUtils.isNotEmpty(((W83bVocesBean)listaVoces.get(i)).getTipoVozDesc())){
	        	if(60<(((W83bVocesBean)listaVoces.get(i)).getTipoVozDesc()).length()){
	        		row.setHeightInPoints((short)(22*((((W83bVocesBean)listaVoces.get(i)).getTipoVozDesc()).length()/60)+1));
	        	}
        	}
        	
        	//Descripcin Voz
        	cell = row.createCell(Short.parseShort("5"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("5"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("9")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bVocesBean)listaVoces.get(i)).getDescVoz())){
        		cell.setCellValue(((W83bVocesBean)listaVoces.get(i)).getDescVoz());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("6")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("7")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("9")); 
        	cell.setCellStyle(this.estiloFila(i,excel));

        	//Descripcin VozEusk
        	cell = row.createCell(Short.parseShort("10"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("10"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("15")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bVocesBean)listaVoces.get(i)).getDescVozEusk())){
        		cell.setCellValue(((W83bVocesBean)listaVoces.get(i)).getDescVozEusk());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("11")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("12")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("13")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("14")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("15")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	if(StringUtils.isNotEmpty(((W83bVocesBean)listaVoces.get(i)).getDescVoz()) 
        			&& StringUtils.isNotEmpty(((W83bVocesBean)listaVoces.get(i)).getDescVozEusk())){
	        	if((((W83bVocesBean)listaVoces.get(i)).getDescVoz()).length()>=(((W83bVocesBean)listaVoces.get(i)).getDescVozEusk()).length()){
		        	if(87<(((W83bVocesBean)listaVoces.get(i)).getDescVoz()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bVocesBean)listaVoces.get(i)).getDescVoz()).length()/87)+1));
		        	}
		        }else{
		        	if(88<(((W83bVocesBean)listaVoces.get(i)).getDescVozEusk()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bVocesBean)listaVoces.get(i)).getDescVozEusk()).length()/88)+1));
		        	}
		        }
        	}
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoVoces.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		return null;
	}
	

	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
		
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
	}
		
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
